<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Filters\QueryPermissionFilters;

class InternalTable extends ParticipantTable
{
    /**
     * The internal usser query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except('actions')
            ->keys()
            ->toArray();

        $query = $this->getConnection()
            ->table('core_participant AS participant')
            ->select($columns)
            ->leftJoin('core_user AS user', 'user.user_id', '=', 'participant.user_id')
            ->where('user.internal', '=', 1)
            ->where('user.status', '=', $this->status)
            ->whereNull('deleted_at');

        return QueryPermissionFilters::for('core.user.internal.browse')
            ->apply($query, 'participant');
    }
}
