<?php

namespace Ignite\Core\Files;

class TemporaryFile extends File
{
    /**
     * @var bool
     */
    protected $deleteOnDestruct = true;

    public function __destruct()
    {
        if ($this->deleteOnDestruct) {
            $this->delete();
        }
    }

    /**
     * Do not delete this file when this class instance is destroyed.
     *
     * @return File
     */
    public function keep(): File
    {
        $this->deleteOnDestruct = false;
        return new File($this->path, $this->disk);
    }
}
