<?php

namespace Ignite\Core\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class NotifyParticipantWithTransactionPointsStatus extends Notification
{
    use SerializesModels, Queueable;

    protected array $data;

    protected Collection $transactions;

    /**
     * NotifyParticipantWithTransactionPointsStatus constructor.
     *
     * @param array      $data
     * @param Collection $transactions
     */
    public function __construct(array $data, Collection $transactions)
    {
        $this->data = $data;
        $this->transactions = $transactions;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * @param mixed $notifiable
     */
    public function toMail($notifiable)
    {
        $programName = config('app.name');

        return (new MailMessage)
            ->subject('You received ' . $this->data['value'] . ' points in ' . $programName)
            ->markdown('emails.participants.points.transaction-points-updates', [
                'data' => $this->data,
                'transactions' => $this->transactions
            ]);
    }
}
