<?php

namespace Ignite\Core\Http\Controllers\Admin;

use Ignite\Core\Contracts\Repositories\ParticipantRepository;
use Illuminate\Http\Request;
use Ignite\Core\Http\Controllers\Controller;
use Ignite\Core\Models\Grid\ParticipantHistoryTable;

class ParticipantHistoryController extends Controller
{
    /**
     * @var ParticipantRepository
     */
    private $participantRepository;

    /**
     * ParticipantOrdersController constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * Show the audit history related to the provided participant.
     *
     * @param  bool|int $participantId
     * @param  ParticipantHistoryTable $table
     * @param  Request $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\View\View
     * @throws \Ignite\Packages\Presenter\Exceptions\PresenterException
     *
     */
    public function index($participantId, ParticipantHistoryTable $table, Request $request)
    {
        $table->with('user_id', $participantId);
        $participant = $user = $this->participantRepository->find($participantId)->present();

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Core::admin.participants.history', compact(
            'participant',
            'participantId'
        ));
    }
}
