<?php

namespace Ignite\Core\Entities;

/**
 * Class Login
 *
 * @var int $id
 * @var int $user_id
 * @var int $session_id
 * @var string $ip_address
 * @var string $browser_name
 * @var string $browser_version
 * @var string $platform_name
 * @var string $platform_version
 * @var string $device
 * @var string $created_at
 */
class Login extends Base
{
    /**
     * The table name.
     *
     * @var string
     */
    protected $table = 'core_logins';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'datetime',
    ];

    /**
     * The relationship to the User model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
