<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Console\Data\Decrypt;
use Ignite\Core\Console\Data\Encrypt;
use Ignite\Core\Console\DecryptColumnCommand;
use Ignite\Core\Console\Dev;
use Ignite\Core\Console\HealthChecks\HorizonCheck;
use Ignite\Core\Console\ImportCommand;
use Ignite\Core\Console\Mail;
use Illuminate\Support\ServiceProvider;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        Decrypt::class,
        DecryptColumnCommand::class,
        Dev\OverrideClass::class,
        Encrypt::class,
        ImportCommand::class,
        Mail\Test::class,
        HorizonCheck::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        return $this->commands;
    }
}
