<?php

namespace Ignite\Core\Contracts\Participant;

use Ignite\Core\Models\Data\UserParticipant;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Fluent;

interface FactoryStrategy
{
    /**
     * Build a UserParticipant consisting of a User model and Participant model.
     *
     * @param Fluent $data
     * @param Model $model
     *
     * @return UserParticipant
     */
    public function make(Fluent $data, Model $model);
}
