@extends('Core::layouts.main')

@section('meta_title', 'Groups Security Management')
@section('page_heading', 'Groups')
@section('page_breadcrumb', 'Groups')

@section('breadcrumb')
    @parent
    <li><a href="#">Security</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.security.users.index') }}">Groups Management</a></small>
    </h1>
@endsection

@section('page_content')
    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            <li><a href="{{ route('admin.security.users.index') }}">Users</a></li>
            <li class="active"><a href="{{ route('admin.security.groups.index') }}">Groups</a></li>
            <li><a href="{{ route('admin.security.permissions.index') }}">Permissions</a></li>
        </ul>
        <div class="tab-content">
            {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
            <form id="groups-delete-form" action="{{ route('admin.security.groups.destroyMany') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
                <input type="hidden" name="ids" value="" id="groups-delete-field" />
            </form>
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
    $(document).ready(function() {
        var $dataTable = $('#dataTableBuilder');
        var buttons = [];

        @can('core.security.groups.create')
        buttons.push({
            text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
            action: function (e) {
                e.preventDefault();
                window.location.href = '{{ route('admin.security.groups.create') }}';
            }
        });
        @endcan

        @can('core.security.groups.delete')
        buttons.push({
            enabled: false,
            text: '<span class="fa fa-trash text-danger"></span> <span class="text-danger">Delete</span>',
            action: function (e, dt, node, conf) {
                var selected = dt.column(0).checkboxes.selected();
                var message = "Are you sure you want to delete the selected groups.";
                if (confirm(message)) {
                    $('#groups-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                    $('#groups-delete-form').submit();
                }
            }
        });
        @endcan

        $dataTable.customButtons({
            buttons: buttons
        });

      // Delete click handler
      $.deleteEntry({
        request: { method: 'DELETE', type: 'json' },
        data: function (button) {
          return {
            _token: "{{ csrf_token() }}",
            id: button.attr('href').split('/').pop()
          }
        },
        onSuccess: function(button) {
          button.closest('tr')
            .animate({'backgroundColor': this.settings.background})
            .fadeOut(function() {
              $(this).remove();
              $dataTable.DataTable().ajax.reload();
            });
        }
      });
    });
    </script>
@endsection