<?php

namespace Ignite\Core\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\SerializesModels;

class NotifyParticipantWithTransactionPointsStatus extends Notification
{
    use SerializesModels, Queueable;

    private array $data;

    /**
     * NotifyParticipantWithTransactionPointsStatus constructor.
     *
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * @param mixed $notifiable
     */
    public function toMail($notifiable)
    {
        $programName = config('app.name');

        return (new MailMessage)
            ->subject('You received ' . $this->data['value'] . ' points in ' . $programName)
            ->markdown('emails.participants.points.transaction-points-updates', [
                'data' => $this->data
            ]);
    }
}
