@extends('Core::layouts.transaction')

@section('page_breadcrumb', 'Waiting Transactions')

@section('page_heading', 'Waiting Transactions')

@section('page_content')
    <div class="row">
        <div class="col-sm-12">
            <form id="waiting-transactions-delete-form" action="{{ route('admin.transactions.resource.destroyMany') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
                <input type="hidden" name="ids" value="" id="waiting-transactions-delete-field" />
            </form>
            <div class="box box-primary">
                <div class="box-body">
                    {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            let $dataTable = $('#dataTableBuilder');
            @can('core.transactions.waiting.delete')
                $dataTable.customButtons({
                    buttons: [{
                        enabled: false,
                        text: '<span class="fa fa-trash text-danger"></span> <span class="text-danger">Delete</span>',
                        action: function (e, dt, node, conf) {
                            let selected = dt.column(0).checkboxes.selected();
                            let message = 'Delete selected waiting transactions?';
                            if (confirm(message)) {
                                $('#waiting-transactions-delete-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                                $('#waiting-transactions-delete-form').submit();
                            }
                        }
                    }]
                });
            @endcan
        });
    </script>
@endsection
