<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Core\Entities\Rule;

class RuleSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'rule';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $rules = $this->parser->parse($this->path());

        foreach ($rules as $rule) {
            $this->seedRule($rule);
        }
    }

    /**
     * Seed a table record.
     *
     * @param  array $rule
     * @return Rule
     */
    private function seedRule($rule)
    {
        return Rule::updateOrCreate(['name' => $rule['name']], $rule);
    }
}
