<section class="chart-metric chart-stat {{ $size }}">
    <div id="{{ $element }}" class="metric-panel metric-style-{{ isset($color) ? $color : 'default' }}">
        <div class="metric-body">
            <p class="metric-label">{{ $label }}</p>
            <h1 class="metric-value">{{ $data ?? [] }}</h1>

            @if (config('core.dashboard.showComparison', false))
                @if (isset($direction) && isset($percentage))
                    @if ($direction === false || $percentage === 0)
                        <p class="metric-change text-gray" data-toggle="tooltip" data-placement="bottom" title="Previously: {{ $previous }}" data-trigger="hover">
                            <span class="fa fa-question metric-icon-bg"></span> Indeterminate
                        </p>
                    @elseif ($direction === 0)
                        <p class="metric-change text-gray">
                            <span class="fa fa-minus metric-icon-bg"></span> No change
                        </p>
                    @elseif ($direction === 1)
                        <p class="metric-change text-green" data-toggle="tooltip" data-placement="bottom" title="Previously: {{ $previous }}" data-trigger="hover">
                            <span class="fa fa-chevron-up metric-icon-bg"></span> @if ($percentage === 0)No previous value @else {{ $percentage }} increase @endif
                        </p>
                    @elseif ($direction === -1)
                        <p class="metric-change text-red" data-toggle="tooltip" data-placement="bottom" title="Previously: {{ $previous }}" data-trigger="hover">
                            <span class="fa fa-chevron-down metric-icon-bg"></span> @if ($percentage === 0)No previous value @else {{ $percentage }} decrease @endif
                        </p>
                    @endif
                @else
                    <p class="metric-change text-gray">
                        <span class="fa fa-question metric-icon-bg"></span> No previous value
                    </p>
                @endif
            @endif
        </div>
        @if (isset($help) && ! empty($help))
            <button type="button" class="metric-help" data-toggle="tooltip" data-placement="left" title="{{ $help ?? '' }}" data-trigger="hover">
                <span class="fa fa-question metric-icon-bg text-gray"></span>
            </button>
        @endif
        @if (isset($series) && ! empty($series))
            <div class="metric-bottom-graph metric-bottom-sparkline xs-hidden" id="{{ $element }}-graph"></div>
        @endif
    </div>
</section>
@push('js')
    @if (isset($series) && ! empty($series))
        <script>
            jQuery(function($) {
                var options2 = {
                    series: [{
                        data: {!! json_encode(array_values($series), JSON_OBJECT_AS_ARRAY) !!},
                    }],
                    labels: {!! json_encode(array_map(function ($value) {
                            $date = DateTime::createFromFormat('Y-m-d', $value);
                            if ($date && $date->format('Y-m-d') === $value) {
                                return $value;
                            }

                            $formatter = new NumberFormatter('en_US', NumberFormatter::ORDINAL);
                            return $formatter->format($value);
                        }, array_keys($series))) !!},
                    yaxis: {
                        type: 'timestamp',
                        forceNiceScale: true,
                        showForNullSeries: false,
                        showAlways: true,
                        min: 0,
                    },
                    stroke: {
                        curve: 'smooth',
                        width: 2
                    },
                    colors: ["{{ $color ?? "#0D8ABC" }}"],
                    chart: {
                        type: 'area',
                        height: 70,
                        sparkline: {
                            enabled: true
                        },
                        animations: {
                            enabled: false,
                            animateGradually: {
                                enabled: false
                            },
                            dynamicAnimation: {
                                enabled: false
                            }
                        }
                    },
                    tooltip: {
                        enabled: true,
                        enabledOnSeries: false,
                        fixed: { enabled: false },
                        x: {
                            show: true,
                            format: 'dd MMM'
                        },
                        y: {
                            show: true,
                            title: {
                                formatter: function (seriesName) {
                                    return '{{ $label }}';
                                }
                            }
                        },
                        marker: { show: false }
                    }
                };

                var chart2 = new ApexCharts(document.querySelector("#{{ $element }}-graph"), options2);
                chart2.render();
            });
        </script>
    @endif
@endpush
