<?php

namespace Ignite\Core\Tests\Unit\Entities\Filters;


use Ignite\Core\Entities\Filters\ParticipantPermissionFilter;
use Ignite\Core\Entities\User;

class DummyParticipantPermissionFilter extends ParticipantPermissionFilter
{
    /** {@inheritdoc} */
    protected function buildWhereExists($query, string $innerAlias, string $outerTableName, ?User $user = null)
    {
        if (! $user) {
            return $query;
        }

        $types = ['Type4'];
        if ($user->participant->state === 'TX') {
            $types = $this->permission === 'core.user.participant.browse'
                ? ['Type1', 'Type2']
                : ['Type1'];
        } else if ($user->participant->state === 'NM') {
            $types = ['Type3'];
        }

        // All other authed users see Type1 & their selves
        return $query->where(function ($query) use ($types, $user) {
            $query->where('user_id', $user->getKey())
                ->orWhereIn('type', $types);
        });
    }
}
