<?php

namespace Ignite\Core\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class WaitingTransactionDeleteManyRequest extends FormRequest
{
    /**
     * Authorize the Waiting Transaction create request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = [
            'ids' => 'required',
        ];

        return $rules;
    }

    /**
     * The customized messages.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'ids.required' => 'You must supply at least one record to delete.',
        ];
    }
}
