<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\Report;

class ReportTableSeeder extends AbstractSeeder
{
    /**
     * The name of the data file.
     *
     * @var string
     */
    protected $file = 'core_report.json';

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        // TODO: Create a repository class
        //$reportRepository = app(ReportRepository::class);
        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath($this->file)
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Report::updateOrCreate(
                    ['name' => $source['name']],
                    $source
                );
            } catch (\Exception $e) {
                echo json_encode($source) . PHP_EOL;
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
