<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Core\Entities\Form;

class CoreFormSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'core_form';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $forms = $this->parser->parse($this->path());

        foreach ($forms as $form) {
            $this->seedForm($form);
        }
    }

    /**
     * Seed a form record.
     *
     * @param  array $form
     * @return Form
     */
    private function seedForm($form)
    {
        return Form::updateOrCreate(['key' => $form['key']], $form);
    }
}
