@extends('Core::layouts.main')

@section('meta_title', 'User Security Management')
@section('page_heading', 'Users')
@section('page_breadcrumb', 'Users')

@section('breadcrumb')
    @parent
    <li><a href="#">Security</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.security.users.index') }}">Users Management</a></small>
    </h1>
@endsection

@section('page_content')
<div class="row">
    <div class="col-sm-8">
        <form id="user-group-form" method="post" class="form-horizontal" action="{{ route('admin.security.users.update', $user) }}">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Manage User Group Associations for {{ $user->fullName() }}</h3>
                </div>
                <div class="box-body bg-gray-light">
                    <div class="form-group">
                        <label for="groups" class="col-sm-5 control-label">
                            <strong>Groups</strong>
                            <p class="font-light help-block">You can assign a user with one or more groups. Each group is associated with specific permissions. When a user is assigned to multiple groups, they inherit the associated permissions of each group.</p>
                        </label>
                        <div class="col-sm-7">
                            <select multiple name="groups[]" id="groups">
                                @foreach ($groups as $group)
                                <option value="{{ $group->id }}" {{ $user->hasGroup($group) ? ' selected' : '' }}>{{ $group->name }}</option>
                                @endforeach
                            </select>
                            <br />
                            <div class="btn-group">
                                <button class="btn btn-sm btn-default" id="select-all">Select All</button>
                                <button class="btn btn-sm btn-default" id="unselect-all">Unselect All</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="box-footer">
                    <div class="form-buttons clearfix">
                        {{ csrf_field() }}
                        {{ method_field('PATCH') }}
                        <input type="hidden" name="user_id" value="{{ $user->getKey() }}">
                        <button type="submit" class="btn btn-primary pull-right" id="save">Save</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    @if (! empty($permissions = $user->getPermissions()->toArray()))
    <div class="col-sm-4">
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><span class="label label-success">{{ count($permissions) }}</span> Permissions allowed for {{ $user->fullName() }}</h3>
            </div>
            <div class="box-footer box-comments">
            @foreach ($permissions as $permission)
                <div class="box-comment">
                    <span class="fa fa-check pull-left" style="position: relative; margin-top: 2px;"></span>
                    <div class="comment-text">
                        {{ $permission['description'] }}
                    </div>
                </div>
            @endforeach
            </div>
        </div>
    </div>
    @endif
</div>
@endsection

@section('js')
    @parent
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('#groups').multiSelect();
            $('#select-all').on('click', function(evt) {
                evt.preventDefault();
                $('#groups').multiSelect('select_all');
            });
            $('#unselect-all').on('click', function(evt) {
                evt.preventDefault();
                $('#groups').multiSelect('deselect_all');
            });
            $('#user-group-form').one('submit', function () {
              $(this).find('#save').text('Saving...').addClass('disabled').prop('disabled', true);
              $('.alert-important').hide();
            });
        });
    </script>
@endsection
