<?php

namespace Ignite\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Queue\SerializesModels;

class NotifyProgramManagerWithPostImportInfo extends Notification
{
    use SerializesModels, Queueable;

    private array $data;

    /**
     * NotifyProgramManagerWithPostImportInfo constructor.
     *
     * @param array $data
     */
    public function __construct(array $data)
    {
        $this->data = $data;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * @param mixed $notifiable
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Import Summary - ' . date('m/d/Y'))
            ->view('emails.imports.post-import-details', [
                'data' => $this->data
            ]);
    }
}
