<section class="chart-metric chart-donut {{ $size }}">
    <div id="{{ $element }}" class="metric-panel metric-style-{{ $color ?? 'default' }}">
        <div class="metric-body">
            <p class="metric-label">{{ $label }}</p>
            <div class="metric-graph-full" style="position: relative; min-height: 335px; display: flex; align-items: center; justify-content: center">
                @if (empty($data->toArray()))
                    <div class="text-muted text-center">
                        <span class="fa fa-exclamation-triangle fa-3x text-gray" style="margin-bottom: 20px"></span>
                        <h3 class="metric-label">No data available</h3>
                        <p class="metric-change">Try choosing a different date range</p>
                    </div>
                @else
                    <div class="chart" id="{{ $element }}-graph"></div>
                @endif
            </div>
        </div>
        @if (! empty($help))
            <button type="button" class="metric-help" data-toggle="tooltip" data-placement="left" title="{{ $help ?? '' }}" data-trigger="hover">
                <span class="fa fa-question metric-icon-bg text-gray"></span>
            </button>
        @endif
    </div>
</section>
@push('js')
    @if (! empty($data->toArray()))
        <script type="text/javascript">
            var options = {
                series: {!! json_encode($data->map->y->values() ?? []) !!},
                labels: {!! json_encode($data->map->x->values() ?? []) !!},
                chart: {
                    height: 320,
                    type: 'donut',
                },
                legend: {
                    position: 'bottom'
                },
                colors: {!! json_encode($colors) !!},
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200,
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            var chart = new ApexCharts(document.querySelector("#{{ $element }}-graph"), options);
            chart.render();
        </script>
    @endif
@endpush
