<?php

namespace Ignite\Core\Helpers;

use NumberFormatter;

class Currency extends Amount
{
    /**
     * @var string
     */
    protected $currency;

    /**
     * Currency constructor.
     *
     * @param $value
     * @param string $currency
     */
    public function __construct($value, $currency = 'USD')
    {
        parent::__construct($value);

        $this->currency = $currency;
    }

    /**
     * Get the value formatted.
     *
     * @param int $decimals
     * @param int $default
     * @param int|null $rounding
     * @return string
     */
    public function format($decimals = 0, $default = 0, $rounding = null)
    {
        if (is_null($this->value) || trim($this->value) === '') {
            $this->value = $default;
        }

        $value = $this->clean($this->value);

        if (! is_null($rounding)) {
            $value = round($value, $decimals, $rounding);
        }

        $locale = config('core.locale.money', 'en-US');

        $formatter = new NumberFormatter($locale, NumberFormatter::CURRENCY);

        return $formatter->formatCurrency($value, $this->currency);
    }
}
