@extends('Core::layouts.cms')

@section('page_heading', 'Pages')
@section('page_breadcrumb', 'Pages')

@section('tab_content')
<div id="cms-list" style="margin: -10px 0;">
    <div x-data="window.PageManager()" x-init="init($refs.list)" id="dt-header" class="clearfix dataTables_wrapper form-inline dt-bootstrap dt-wrapper-padding">
        <div class="clearfix">
            @can('core.cms.pages.create')
            <div class="dt-buttons btn-group dt-margin-right">
                <a tabindex="0" href="/admin/cms/pages/create" class="btn btn-default">
                    <span class="fa fa-plus text-success"></span> <span class="text-success">{{ __('Create') }}</span>
                </a>
            </div>
            @endcan
            <div id="dataTableBuilder_filter" class="dataTables_filter">
                <label>{{ __('Search') }} <input x-model="filterKey" type="text" class="form-control input-sm"></label>
            </div>
        </div>
        <ul x-ref="list" class="nav nav-pills nav-stacked dt-table-border" x-show="! loading">
            <template x-for="page in filteredPages()" :key="page.id">
                <li class="nav-stacked-row" x-bind:data-id="page.id">
                    <div x-bind:id="'page-' + page.id" x-bind:data-id="page.id" class="nav-stacked-item">
                        <span x-show="window.canReorder" class="nav-stacked-drag" x-bind:class="{'nav-no-drag': isHome(page) || ! window.canReorder}">
                            <span class="fa fa-arrows" x-show="!isHome(page)"></span>
                        </span>
                        <a x-bind:href="editUrl(page)" class="nav-stacked-title" x-text="page.label" x-show="window.canUpdate"></a>
                        <span :href="editUrl(page)" class="nav-stacked-title" x-text="page.label" x-show="! window.canUpdate"></span>
                        <span class="nav-stacked-published_at text-muted hidden-xs">Publish Date: <span x-text="publishDate(page)"></span> (<span x-text="page.published_ago"></span>)</span>
                        <span title="Click here to open the live version of the page." class="nav-stacked-menu text-muted pull-right">
                            <a x-bind:href="viewUrl(page)"><span class="fa fa-globe"></span></a>
                        </span>
                        <span class="nav-stacked-menu text-muted pull-right" x-on:click.prevent="toggleVisibility(page)">
                            <span class="fa fa-eye" x-show="! isTogglingVisibility(page) && isVisibleInMenu(page)"></span>
                            <span class="fa fa-eye-slash" x-show="! isTogglingVisibility(page) && isInvisibleInMenu(page)"></span>
                            <span class="fa fa-refresh fa-spin fa-fw" x-show="isTogglingVisibility(page)"></span>
                        </span>
                        <span class="nav-stacked-status pull-right" x-on:click.prevent="toggleStatus(page)">
                            <span class="fa fa-circle text-green" x-show="! isTogglingStatus(page) && isActive(page)"></span>
                            <span class="fa fa-circle text-danger" x-show="! isTogglingStatus(page) && isInactive(page)"></span>
                            <span class="fa fa-refresh fa-spin fa-fw" x-show="isTogglingStatus(page)"></span>
                        </span>
                        <span x-show="isAlias(page)" title="System Page" class="nav-stacked-menu text-muted pull-right">
                            <span class="fa fa-rocket"></span>
                        </span>
                        <span class="nav-stacked-menu text-muted pull-right" title="Protected Page" x-show="isProtected(page)">
                            <span class="fa fa-lock"></span>
                        </span>
                    </div>
                </li>
            </template>
        </ul>
        <div class="overlay" x-show="loading">
            <div class="text-center" style="padding-top: 50px; padding-bottom: 50px">
                <i class="fa fa-refresh fa-spin fa-2x"></i>
                <p>Retrieving pages...</p>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
    <script type="text/javascript">
        window.Translation = window.Translation || {};
        window.Translation.noRecords = "{{ __('No pages created yet.') }}";
        window.Translation.viewPageFront = "{{ __('Click here to open the live version of the page.') }}";
        window.Translation.visible = "{{ __('Click to hide the page in the navigation menu.') }}";
        window.Translation.invisible = "{{ __('Click to show the page in the navigation menu.') }}";
        window.Translation.active = "{{ __('The page is visible on the website. Click to deactivate the page.') }}";
        window.Translation.inactive = "{{ __('The page is not visible on the website. Click to activate the page.') }}";
        window.Translation.protected = "{{ __('The page is protected.') }}";
        window.Pages = window.Pages || {};
        window.Pages.indexUrl = "{{ route('admin.pages.index') }}";
        window.Pages.createUrl = "{{ route('admin.pages.create') }}";
        window.Pages.editUrl = '/admin/cms/pages/edit';
        window.Pages.toggleUrl = '/admin/cms/pages/api/toggle';
        window.Pages.reorderUrl = '/admin/cms/pages/api/reorder';
        window.canUpdate = {{ auth()->user()->can('core.cms.pages.update') ? 'true' : 'false' }};
        window.canReorder = {{ auth()->user()->can('core.cms.pages.reorder') ? 'true' : 'false' }};
        window.canToggleStatus = {{ auth()->user()->can('core.cms.pages.status-toggle') ? 'true' : 'false' }};
        window.canToggleVisibility = {{ auth()->user()->can('core.cms.pages.visibility-toggle') ? 'true' : 'false' }};

        window.Laravel = window.Laravel || {};
        window.Laravel.baseUrl = "{{ config('app.url') }}";
        window.Laravel.csrfToken = "{{ csrf_token() }}";
    </script>
    <script type="text/javascript" src="{{ asset('vendor/ignite/js/cms/page-manager.js') }}"></script>
@endpush
