<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Events\EnrollmentComplete;
use Ignite\Core\Listeners\AssignUserToGroup;
use Ignite\Core\Listeners\AttachWaitingTransactions;
use Ignite\Core\Listeners\CompleteEnrollment;
use Ignite\Core\Listeners\ScaffoldTheme;
use Ignite\Core\Listeners\SendWelcomeEmail;
use Ignite\Core\Listeners\StopIfImpersonating;
use Ignite\Core\Listeners\StoreLogin;
use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\PasswordReset;
use Illuminate\Auth\Events\Registered;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Mail\Events\MessageSending;
use Illuminate\Support\Facades\Event;
use SocialiteProviders\Manager\SocialiteWasCalled;
use SocialiteProviders\SalesForce\SalesForceExtendSocialite;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'ignite.theme.scaffolded' => [
            ScaffoldTheme::class,
        ],
        SocialiteWasCalled::class => [
            SalesForceExtendSocialite::class
        ],
        Login::class => [
            StopIfImpersonating::class,
            StoreLogin::class,
        ],
        Registered::class => [
            AssignUserToGroup::class,
            SendWelcomeEmail::class,
        ],
        PasswordReset::class => [
            CompleteEnrollment::class,
        ],
        EnrollmentComplete::class => [
            AttachWaitingTransactions::class
        ]
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();
        $this->bootPostmarkTrackingHeader();
    }

    /**
     * Listen for the MessageSending event and add the Postmark tracking header.
     */
    protected function bootPostmarkTrackingHeader()
    {
        $messageStreamId = config('mail.mailers.postmark.message_stream_id');
        if ($messageStreamId) {
            Event::listen(MessageSending::class, function (MessageSending $event) use ($messageStreamId) {
                $event->message->getHeaders()->addTextHeader('X-PM-Message-Stream', $messageStreamId);
            });
        }
    }
}
