<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Core\Entities\Page;

class CmsPagesSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'cms_pages';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $pages = $this->parser->parse($this->path());

        foreach ($pages as $page) {
            $this->seedPage($page);
        }
    }

    /**
     * Remove pages from CMS.
     *
     * @param  array $pages
     * @return bool
     */
    public function remove($pages)
    {
        return Page::whereIn('code', $pages)->delete();
    }

    /**
     * Seed a table record.
     *
     * @param  array $page
     * @return Page
     */
    private function seedPage($page)
    {
        return Page::updateOrCreate(['code' => $page['code']], $page);
    }
}
