<section class="chart-metric chart-table {{ $size }}">
    <div id="{{ $element }}" class="metric-panel metric-style-{{ $color ?? 'default' }}">
        <div class="metric-body">
            <p class="metric-label">{{ $label }}</p>
            <div class="metric-graph-full table-responsive" style="min-height: 200px;">
                @if (isset($data) && $data->isNotEmpty())
                    <table class="table">
                        @if($headers)
                            <thead>
                            @foreach($headers as $header)
                                <th class="text-nowrap">{{ $header }}</th>
                            @endforeach
                            </thead>
                        @endif
                        <tbody>
                        @foreach($data as $row)
                            <tr>
                                @foreach($row as $item)
                                    <td class="text-nowrap">{{ $item }}</td>
                                @endforeach
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                @else
                    <div class="text-muted text-center">
                        <span class="fa fa-exclamation-triangle fa-3x text-gray" style="margin-bottom: 20px"></span>
                        <h3 class="metric-label">No data available</h3>
                        <p class="metric-change">Try choosing a different date range</p>
                    </div>
                @endif
            </div>
        </div>
        @if (! empty($help))
            <button type="button" class="metric-help" data-toggle="tooltip" data-placement="left" title="{{ $help ?? '' }}" data-trigger="hover">
                <span class="fa fa-question metric-icon-bg text-gray"></span>
            </button>
        @endif
    </div>
</section>
