<?php

namespace Ignite\Core\Listeners;

use Ignite\Core\Entities\Group;
use Ignite\Core\Entities\User;
use Illuminate\Auth\Events\Registered;

class AssignUserToGroup
{
    /**
     * When a user enrolls event.
     *
     * @param Registered $event
     */
    public function handle($event)
    {
        $group = $this->getParticipantGroup();

        /** @var User $user */
        $user = $event->user;
        $user->status = User::STAT_PENDING;
        $user->groups()->attach($group->getKey());
        $user->save();
    }

    /**
     * The the Group model for a Participant.
     *
     * @return mixed
     */
    protected function getParticipantGroup()
    {
        return Group::where('key', 'participant')->first();
    }
}
