<?php

namespace Ignite\Core\Entities\Filters;

use Ignite\Core\Entities\User;

/**
 * This has no effect on queries and can be applied to any type of query.
 * @see \Ignite\Core\Entities\Filters\QueryPermissionFilters
 * @see config core.query_filters.permissions
 */
class NullQueryPermissionFilter extends BaseQueryPermissionFilter
{
    /**
     * {@inheritdoc}
     */
    public function getTable(): string
    {
        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function getKeyName(): string
    {
        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function canAccess($model, ?User $user = null): bool
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function apply($query, ?string $tableAlias = null, ?User $user = null)
    {
        return $query;
    }

    /**
     * {@inheritdoc}
     */
    protected function isForTable($table): bool
    {
        return true;
    }
}
