<?php

namespace Ignite\Core\Console\Mail;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class Test extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ignite:core:mail:test {toAddress}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send a test email to the given address.';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Mail::raw('Just a test email', function ($message) {
            $message->from(config('mail.from.address'), 'Ignite');

            $message->to($this->argument('toAddress'));
        });
    }
}
