<?php

namespace Ignite\Core\Presenters;

use Ignite\Core\Facades\Format;

trait CommonlyPresentable
{
    /**
     * Check if a value is falsey and return No or Yes if truthy.
     *
     * @param  mixed $value
     * @return string
     */
    protected function formatYesNo($value)
    {
        return (bool) $value ? trans('Core::core.common.yes') : trans('Core::core.common.no');
    }


    /**
     * Format an amount with a currency.
     *
     * @param mixed  $value
     * @param string $currency
     * @param int    $decimals
     * @return string
     */
    protected function formatCurrency($value, $currency = '$', $decimals = 0)
    {
        // @todo setting('core.currency');
        return Format::currency($value, $currency, $decimals);
    }

    /**
     * Format a number with a percentage.
     *
     * @param mixed $value
     * @param int   $decimals
     * @return string
     */
    protected function formatPercentage($value, $decimals = 0)
    {
        // TODO: Add a helper class to handle this.
        return Format::amount($value, $decimals) . '%';
    }
}
