<?php

namespace Ignite\Core\Providers;

use Ignite\Core\Console\DecryptColumnCommand;
use Illuminate\Support\ServiceProvider;
use Ignite\Core\Console\Data\Encrypt;
use Ignite\Core\Console\ImportCommand;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        ImportCommand::class,
        Encrypt::class,
        DecryptColumnCommand::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        return $this->commands;
    }
}
