<?php

namespace Ignite\Core\Entities;

class UserGroup extends Base
{
    /**
     * The custom table name.
     * @var string
     */
    protected $table = 'core_user_group';

    /**
     * Eloquent event listeners.
     */
    public static function boot()
    {
        parent::boot();

        static::saved(function () {
            app('authorization')->forgetPermissions()->registerPermissions();
        });
    }

    /**
     * The relationship of the user's group reference to the actual user record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'user_id');
    }

    /**
     * The relationship of the user's group reference to the actual group record.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function group()
    {
        return $this->belongsTo(Group::class, 'group_id', 'id');
    }
}
