<?php

namespace Ignite\Core\Contracts\Repositories;

use Ignite\Core\Entities\Participant;

interface ParticipantRepository
{
    /**
     * The default query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query();

    /**
     * The participant types.
     *
     * @return array
     */
    public function getTypes();

    /**
     * The participant statuses.
     *
     * @return array
     */
    public function getStatuses();

    /**
     * Find a participant by id.
     *
     * @param  int $id
     * @param  bool $includeTrashed
     * @return Participant
     */
    public function find($id, $includeTrashed = false);

    /**
     * Find a participant by email.
     *
     * @param  string $email
     * @return Participant
     */
    public function findByEmail($email);

    /**
     * Find the currently authenticated participant.
     *
     * @return Participant
     */
    public function findAuthenticated();

    /**
     * Create a new participant.
     *
     * @param  array $data
     * @return Participant
     */
    public function create(array $data);

    /**
     * Update an existing participant.
     *
     * @param  int $id
     * @param  array $data
     * @return Participant
     */
    public function update($id, array $data);

    /**
     * Change a participant's password.
     *
     * @param int    $id
     * @param string $old
     * @param string $new
     */
    public function changePassword($id, $old, $new);

    /**
     * Trash a participant.
     *
     * @param  int $id
     * @return bool
     * @throws \Exception
     */
    public function trash($id);

    /**
     * Restore a trashed participant.
     *
     * @param  int $id
     * @return bool
     */
    //public function restore($id);

    /**
     * Delete a participant.
     *
     * @param int $id
     * @return bool
     */
    public function delete($id);
}
