<?php

namespace Ignite\Core\Listeners;

use Ignite\Core\Emails\Enrolled;
use Illuminate\Auth\Events\Registered;
use Illuminate\Mail\Mailer;

class SendWelcomeEmail
{
    /**
     * @var Mailer
     */
    private $mailer;

    /**
     * SendWelcomeEmail constructor.
     *
     * @param Mailer $mailer
     */
    public function __construct(Mailer $mailer)
    {
        $this->mailer = $mailer;
    }

    /**
     * When a user enrolls event.
     *
     * @param Registered $event
     */
    public function handle(Registered $event)
    {
        $this->mailer->later(now()->addSeconds(30), new Enrolled($event->user));
    }
}
