<?php

return [
    'name' => 'Core',

    /**
     * Should we consider the core_user.email field the username field?
     * If not, we'll use the core_user.username field.
     */
    'use_email_as_username' => true,

    'google' => [
        'analytics' => [
            // the older universal analytics tracking code like UA-111111111-4
            'tracking' => env('GOOGLE_ANALYTICS_TRACKING_ID', ''),
            // the new G4 tracking code like G-1A2B3C4D5E
            'tracking_g4' => env('GOOGLE_ANALYTICS4_TRACKING_ID', ''),
            // a UA View ID, preferably one that filters our the office IP
            'view' => env('GOOGLE_ANALYTICS_VIEW_ID', env('GOOGLE_ANALYTICS_CODE', '')),
            'key_file' => base_path(env('GOOGLE_KEY_FILE', 'vendor/ignite/modules/Core/resources/services/ignite-platform-3-4fcc58082a35.json')),
        ],
    ],

    // The program type determines the content and features displayed to the
    // participant on certain pages. Currently, the recognized/understood
    // types are: redemption, payout. Otherwise default to redemption.
    'program_type' => 'redemption',

    'locale' => [
        'money' => 'en_US.UTF-8',
    ],

    'auth' => [
        'drivers' => [
            env('APP_AUTH_SSO_DEFAULT', null),
        ],
    ],

    // Ignite 3 Core supports "demo mode" where the system will generate some
    // sample demoable data for participants, claims and catalog. The next
    // step is to move the code from Core to a dedicated Demo module.
    'demo' => [
        'allow_events_in_console' => false,
    ],

    // The Ignite 3 admin account is added during the seeding process via the
    // command line. In order to dynamically change the admin credentials
    // at install time, you can set the following via environment vars.
    'admin' => [
        'email' => env('ADMIN_EMAIL', 'it@brightspot.email'),
        'password' => env('ADMIN_PASSWORD', 'br1ght3r1d34s!'),
    ],

    /**
     * Source models implement the Source interface and provide a toDropdown method which can be used to
     * retrieve select dropdown values in a polymorphic way for use in forms.
     *
     * @see Ignite\Core\Contracts\Source
     */
    'source' => [
        'models' => [
            'countries' => Ignite\Core\Models\Options\Countries::class,
            'states' => Ignite\Core\Models\Options\States::class,
            'canada_states' => Ignite\Core\Models\Options\CanadaStates::class,
            'user_states' => Ignite\Core\Models\Options\UserStates::class,
            'participant_types' => Ignite\Core\Models\Options\ParticipantTypes::class,
            'user_statuses' => Ignite\Core\Models\Options\UserStatuses::class,
            'user_types' => Ignite\Core\Models\Options\UserTypes::class,
        ],
    ],

    // At certain points in the Ignite 3 Core, HTML is saved to the database,
    // in order to protect our sites from XSS attacks we purify the html
    // before storing it, so we are safe to render it to the template.
    'html' => [
        // HTML Purifier Options - http://htmlpurifier.org/live/configdoc/plain.html
        'options' => [
            'Core.Encoding' => 'UTF-8',
            'HTML.Doctype' => 'XHTML 1.0 Strict',
            'HTML.Allowed' => 'h1[class],h2[class],h3[class],h4[class],h5[class],h6[class],div[class|style],blockquote[class],ul[class|style],ol[class|style],li[class],p[style|class],b[class|style],strong[class|style],i[class|style],em[class|style],a[class|style|href|title|target],br[class|style],span[class|style],img[class|style|width|height|alt|src],table[class|style|summary],hr[class|style],tbody[class|style],thead[class|style],td[class|style|abbr],tr[class|style],th[class|style|abbr],tfoot',
            'HTML.MaxImgLength' => null,
            'CSS.MaxImgLength' => null,
            'CSS.AllowedProperties' => 'font-size,font-weight,float,font-style,text-align,text-decoration,padding,margin,color,background-color,text-align,max-width,max-height,height,width',
            'CSS.AllowTricky' => true,
            'AutoFormat.AutoParagraph' => true,
            'AutoFormat.RemoveEmpty' => false,
            'AutoFormat.RemoveSpansWithoutAttributes' => true,
        ],
    ],

    'participant' => [
        'states' => [
            'map' => [
                'US' => Ignite\Core\Models\Options\States::class,
                'CA' => Ignite\Core\Models\Options\CanadaStates::class,
            ],
            'default' => Ignite\Core\Models\Options\States::class,
        ],

        'types' => [
            'Account Executive' => 'Account Executive',
            // 'Sales Engineer' => 'Sales Engineer',
            // 'Sales Manager' => 'Sales Manager',
            // 'Sales Engineer Manager' => 'Sales Engineer Manager',
        ],

        'factory' => [
            'strategy' => Ignite\Core\Services\Participant\Strategy\DefaultStrategy::class,
        ],

        'emails' => [
            'enrollment' => [
                'active' => true,
                'template' => 'emails.auth.registered',
                'subject' => 'Activate your Registration - Enrollment Confirmation',
            ],
        ],
    ],

    'dashboard' => [
        'default' => 'Core',
        'autolocate' => false,
        'setupFilename' => 'settings',
        'startCurrent' => now()->subDays(7)->startOfDay()->format('Y-m-d'),
        'endCurrent' => now()->endOfDay()->format('Y-m-d'),
        'startPrevious' => now()->subDays(14)->format('Y-m-d'),
        'endPrevious' => now()->subDays(7)->format('Y-m-d'),
        'comparison' => 'range',
        'showComparison' => false,
    ],

    'cms' => [
        'disk' => env('CMS_STORAGE_DISK', 'public'),
        'folder' => env('CMS_STORAGE_FOLDER', 'uploads'),
        'templates' => [
            'default' => 'Default',
        ],
    ],

    'transaction' => [
        'resource' => [
            'identifier' => 'email',
            'resolvers' => [
                'user' => Ignite\Core\Models\Import\Resolvers\UserResolver::class,
            ],
        ],
    ],

    'report' => [
        'filters' => [
            Ignite\Core\Models\Report\EnrollmentReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Sign Up Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.approved_at',
                    'label' => 'Enroll Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'label' => 'Country',
                    'field' => 'participant.country',
                    'options' => ['US' => 'US', 'CA' => 'Canada'],
                ],
            ],
            Ignite\Core\Models\Report\TaxReport::class => [
                [
                    [
                        'view' => 'Core::admin.report.filters.daterange',
                        'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                        'request' => ['field', 'value', 'startDate', 'endDate'],
                        'field' => 'transaction.transaction_date',
                        'label' => 'Transaction Date',
                    ],
                    [
                        'view' => 'Core::admin.report.filters.daterange',
                        'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                        'request' => ['field', 'value', 'startDate', 'endDate'],
                        'field' => 'transaction.transaction_date',
                        'label' => 'Transaction Date',
                    ],
                    [
                        'view' => 'Core::admin.report.filters.country',
                        'scope' => Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                        'request' => ['field', 'value'],
                        'field' => 'participant.country',
                        'label' => 'Country',
                        'options' => ['US' => 'US', 'CA' => 'Canada'],
                    ],
                ],
            ],
            Ignite\Core\Models\Report\TotalEarnedReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'transaction.transaction_date',
                    'label' => 'Transaction Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Enrolled Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'field' => 'participant.country',
                    'label' => 'Country',
                    'options' => ['US' => 'US', 'CA' => 'Canada'],
                ],
            ],
            Ignite\Core\Models\Report\TotalRedeemedReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'transaction.transaction_date',
                    'label' => 'Transaction Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Enrolled Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'field' => 'participant.country',
                    'label' => 'Country',
                    'options' => ['US' => 'US', 'CA' => 'Canada'],
                ],
            ],
            Ignite\Core\Models\Report\TotalBalanceReport::class => [
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'transaction.transaction_date',
                    'label' => 'Transaction Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.daterange',
                    'scope' => Ignite\Core\Models\Grid\Scopes\DateScope::class,
                    'request' => ['field', 'value', 'startDate', 'endDate'],
                    'field' => 'participant.created_at',
                    'label' => 'Enrolled Date',
                ],
                [
                    'view' => 'Core::admin.report.filters.country',
                    'scope' => Ignite\Core\Models\Grid\Scopes\CountryScope::class,
                    'request' => ['field', 'value'],
                    'field' => 'participant.country',
                    'label' => 'Country',
                    'options' => ['US' => 'US', 'CA' => 'Canada'],
                ],
            ],
        ],
        'participant-types' => Ignite\Core\Entities\Participant::get('type')->toArray(),
    ],

    'seeder' => [
        // the path to your seeder files, like 'modules/Program/database/data'
        // if left null, usually defaults to 'vendor/ignite/modules/Core/database/data'
        'path' => 'modules/Program/database/data',
    ],

    'import' => [
        'queue' => true,

        // if your imports needs more time, you should set this to 'long-running'
        // and create configurations for it in config/horizon.php (timeout parameter)
        // and in config/queue.php (retry_after parameter)
        'queue_connection' => '',

        'timeout' => 300,

        // Where import files and logs will be stored.
        'directory' => 'imports',
        'disk' => 'local',

        'reader' => [
            'pattern' => '/\[(?P<date>.*)\] (?P<logger>\w+).(?P<level>\w+): (?P<message>.+) (?P<context>[\[\{].*[\]\}]) (?P<extra>[\[\{].*[\]\}])/',
        ],

        'types' => [
            'participant' => [
                'class' => Ignite\Core\Services\Importers\Participants::class,
                'label' => 'Participant',
            ],
            'transaction' => [
                'class' => Ignite\Core\Services\Importers\Transactions::class,
                'label' => 'Transaction',
            ],
        ],
    ],

    'file_encryption' => [
        'default' => 'pgp',

        'providers' => [
            'pgp' => [
                'driver' => \Ignite\Core\Files\Encryption\PGPFileEncrypter::class,
                // Some help on gpg: https://itsfoss.com/gpg-encrypt-files-basic/
                // Using a key server might be useful: https://www.privex.io/articles/what-is-gpg
                'decryption' => [
                    // The passphrase for the key you're decrypting with. For Travelers, see the
                    // "Travelers - Brightspot PGP Files" entry in 1Password:
                    // https://start.1password.com/open/i?a=GZULADRXBZBKRCDLSU6O5DLWZA&v=m5hvyi7jjlywfkscea4sdzunee&i=xtpuqj6dpdu3dylassgpptk4t4&h=my.1password.com
                    'passphrase' => env('PGP_DECRYPTION_PASSPHRASE'),
                ],
                'encryption' => [
                    // The recipient is used to determine which public key to use for encryption. This can be either
                    // the recipient's name or email (see gpg --list-keys). For Travelers, this is
                    // "security@travelers.com". See "Travelers - Public PGP Key" entry in 1Password:
                    // https://start.1password.com/open/i?a=GZULADRXBZBKRCDLSU6O5DLWZA&v=m5hvyi7jjlywfkscea4sdzunee&i=n2g27bczuhcv7s35gougabglg4&h=my.1password.com
                    'recipient' => env('PGP_ENCRYPTION_RECIPIENT'),
                ],
            ],
        ],
    ],

    'query_filters' => [
        // This is a mapping from permission to query permission filter class. Not all of our user permissions are
        // defined here. You're not limited to those defined here. In your program application, only define those
        // you need for that program. (assigning to null and not including the permission in this array are
        // equivalent).
        //
        // Many of these are setup so that when you add a filter class for a program, it will start filtering things
        // in Core without having to override classes. Some in this list will still need some work done in Core to
        // cover all possible places we could filter, however.
        'permissions' => [
            // You can extend \Ignite\Activity\Entities\Filters\ActivitySubmissionPermissionFilter::class for these permissions.
            'activity.submission.all.browse' => null,
            'activity.submission.all.delete' => null,
            'activity.submission.all.update' => null,
            'activity.submission.claims.browse' => null,
            'activity.submission.claims.delete' => null,
            'activity.submission.claims.update' => null,

            // You can extend \Ignite\Catalog\Entities\Filters\OrderPermissionFilter for this permission.
            'catalog.order.browse' => null,

            // Implement depending on how you've implemented your claims tables (e.g. Avaya's \Program\Entities\Filters\ClaimPermissionFilter).
            'claim.all.browse' => null,
            'claim.browse' => null,
            'claim.create' => null,
            'claim.approved.browse' => null,
            'claim.cancelled.browse' => null,
            'claim.declined.browse' => null,
            'claim.issued.browse' => null,
            'claim.issued.view' => null,
            'claim.pending.browse' => null,
            'claim.process.view' => null,
            'claim.trashed.browse' => null,

            // You can extend \Ignite\Activity\Entities\Filters\OfferPermissionFilter for this permission.
            'claim.offer.offer.browse' => null,

            // You can extend \Ignite\Core\Entities\Filters\ReportPermissionFilter for these permissions.
            'core.report.browse' => null,
            'core.report.export' => null,
            'core.report.view' => null,

            // You can extend \Ignite\Core\Entities\Filters\WaitingTransactionPermissionFilter for these permissions.
            'core.transactions.waiting.assign' => null,
            'core.transactions.waiting.browse' => null,

            // You can extend \Ignite\Core\Entities\Filters\TransactionPermissionFilter for these permissions.
            'core.user.transaction.browse' => null,

            // You can extend \Ignite\Core\Entities\Filters\UserPermissionFilter for these permissions.
            'core.user.browse' => null,
            'core.user.impersonate' => null,
            'core.user.internal.browse' => null,
            'core.user.trashed.browse' => null,
            'core.user.trashed.restore' => null,
            'core.user.trashed.shred' => null,

            // You can extend \Ignite\Core\Entities\Filters\ParticipantPermissionFilter for these permissions.
            'core.user.participant.browse' => null,
            'core.user.participant.delete' => null,
            'core.user.participant.update' => null,
        ],
    ],

    /* HTTP Headers
     * -------------------------------------------------- //
     * Default configuration for HTTP headers.
     * Our current nginx configuration has the following
     * already configured, so we hide them by default
     * because for some unknown reason, they aren't being
     * removed automatically. Technically, we could
     * remove them from our configuration and update this
     * file to automatically configure them:
     *
     * X-Frame-Options "SAMEORIGIN"
     * X-XSS-Protection "1; mode=block"
     * X-Content-Type-Options "nosniff"
     *
     * Last, but not least, make sure to add the
     * following middleware to the application's
     * App\Http\Kernel $middleware property. It may be
     * changed to be auto-loaded in the future, but as
     * of right now, it is not:
     *
     * \Ignite\Core\Http\Middleware\SecureHeadersMiddleware::class,
     * -------------------------------------------------- */
    'secure_headers' => [
        'show_content_security_policy' => env('HEADER_SHOW_CONTENT_SECURITY_POLICY', true),
        'show_referrer_policy' => env('HEADER_SHOW_REFERRER_POLICY', true),
        'show_strict_transport_security' => env('HEADER_SHOW_STRICT_TRANSPORT_SECURITY', true),
        'show_x_content_type_options' => env('HEADER_SHOW_X_CONTENT_TYPE_OPTIONS', false),
        'show_x_frame_options' => env('HEADER_SHOW_X_FRAME_OPTIONS', false),
        'show_x_xss_protection' => env('HEADER_SHOW_X_XSS_PROTECTION', false),
    ],
];
