<?php

namespace Ignite\Core\Services\Google\Analytics;

use Google_Client;
use Google_Exception;
use Google_Service_AnalyticsReporting;
use Google_Service_AnalyticsReporting_DateRange;
use Google_Service_AnalyticsReporting_Metric;
use Google_Service_AnalyticsReporting_ReportRequest;

class Client
{
    /**
     * @var Google_Client
     */
    private $client;

    /**
     * Client constructor.
     *
     * @param Google_Client $client
     */
    public function __construct(Google_Client $client)
    {
        $this->client = $client;
    }

    /**
     * Get an instance of the analytics reporting class.
     *
     * @param array $scopes
     *
     * @return Google_Service_AnalyticsReporting
     * @throws Google_Exception
     */
    public function instance($scopes = [])
    {
        $scopes = ! empty($scopes) ? $scopes : [
            'https://www.googleapis.com/auth/analytics.readonly'
        ];

        $this->client->setApplicationName("Ignite 3");
        $this->client->setAuthConfig(config('core.google.analytics.key_file'));
        $this->client->setScopes($scopes);

        return new Google_Service_AnalyticsReporting($this->client);
    }

    /**
     * The date range class.
     *
     * @return Google_Service_AnalyticsReporting_DateRange
     */
    public function period()
    {
        return new Google_Service_AnalyticsReporting_DateRange();
    }

    /**
     * The metrics class.
     *
     * @return Google_Service_AnalyticsReporting_Metric
     */
    public function metrics()
    {
        return new Google_Service_AnalyticsReporting_Metric();
    }

    /**
     * The report class.
     *
     * @return Google_Service_AnalyticsReporting_ReportRequest
     */
    public function report()
    {
        return new Google_Service_AnalyticsReporting_ReportRequest();
    }
}
