<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Claim\Entities\Table;

class CoreTableSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'core_table';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $tables = $this->parser->parse($this->path());

        foreach ($tables as $table) {
            $this->seedTable($table);
        }
    }

    /**
     * Seed a table record.
     *
     * @param  array $table
     * @return Table
     */
    private function seedTable($table)
    {
        return Table::updateOrCreate(['key' => $table['key']], $table);
    }
}
