<?php

namespace Ignite\Core\Http\Controllers\Api;

use Ignite\Core\Http\Controllers\Controller;
use Ignite\Core\Contracts\Repositories\BlockRepository;
use Ignite\Core\Models\Grid\BlockTable;

class BlockController extends Controller
{
    /** @var BlockRepository */
    protected $blockRepository;

    /**
     * Create a new controller instance.
     *
     * @param BlockRepository $blockRepository
     */
    public function __construct(BlockRepository $blockRepository)
    {
        $this->blockRepository = $blockRepository;
    }

    /**
     * List the blocks as a data grid.
     *
     * @param  BlockTable $datatable
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(BlockTable $datatable)
    {
        return $datatable->ajax();
    }
}
