@php
    $field = request('field', $filter['field']);
    $key = md5($report->class);
    $value = session()->get($key)[$field]['value'] ?? null;
@endphp

<div class="form-group report-filter-country">
    <label class="control-label col-sm-3" for="country_filter_value">{{ $filter['label'] ?? 'Country' }}</label>
    <div class="col-sm-9">
        <input type="hidden" name="filters[{{ $field }}][field]" value="{{ $field }}" />
        <select id="country_filter_value" name="filters[{{ $field }}][value]" class="form-control select2 report-filter-country">
            <option value="">Do not specify</option>
            @foreach ($filter['options'] as $country => $label)
                <option data-label="{{ $label }}" data-country="{{ $country }}" value="{{ $country }}" {{ $country === $value ? 'selected' : '' }}>{{ $label }}</option>
            @endforeach
        </select>
    </div>
</div>
