<?php

namespace Ignite\Core\Models\Grid\Scopes;

use Yajra\DataTables\Contracts\DataTableScope;

class CountryScope implements DataTableScope
{
    /** @var string */
    private $field;

    /** @var string */
    private $value;

    /**
     * CountryScope constructor.
     *
     * @param string $field
     * @param string $value
     */
    public function __construct($field, $value = null)
    {
        $this->field = $field;
        $this->value = $value;
    }

    /**
     * Apply the date scope to the query.
     *
     * @param \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Query\Builder $query
     *
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Query\Builder
     */
    public function apply($query)
    {
        if (empty($this->value)) {
            return $query;
        }

        return $query->where($this->field, '=', $this->value);
    }
}
