<?php

namespace Ignite\Core\Tests\Unit\Files\Processors;

use Ignite\Core\Files\Encryption\PGPFileEncrypter;
use Ignite\Core\Files\File;
use Ignite\Core\Files\Processors\DecryptFileProcessor;
use Ignite\Core\Files\TemporaryFile;
use Ignite\Core\Tests\TestCase;
use Illuminate\Support\Facades\Storage;

class DecryptFileProcessorTest extends TestCase
{
    /** @test */
    public function decrypts_files_in_a_temporary_location()
    {
        // Arrange
        Storage::fake();
        $file = File::new('SomeFile.txt.pgp');
        $file->put('some contents!!');
        $file = (new PGPFileEncrypter('pgp'))->encrypt($file, $file);

        // Execute
        $tempFile = (new DecryptFileProcessor('pgp'))->toTemporary()->run($file);

        // Check
        $this->assertInstanceOf(TemporaryFile::class, $tempFile);
        $this->assertEquals('some contents!!', $tempFile->get());
        $this->assertEquals(
            'some contents!!',
            (new PGPFileEncrypter('pgp'))->decrypt($file)->get()
        );
    }

    /** @test */
    public function decrypts_files_to_a_specified_location()
    {
        // Arrange
        Storage::fake();
        $file = File::new('SomeFile.txt.pgp');
        $file->put('some contents!!');
        $file = (new PGPFileEncrypter('pgp'))->encrypt($file, $file);

        // Execute
        $destinationFile = (new DecryptFileProcessor('pgp'))
            ->destination(File::new('Destination.txt'))
            ->run($file);

        // Check
        $this->assertTrue($destinationFile->is(File::new('Destination.txt')));
        $this->assertFalse($destinationFile->is($file));
        $this->assertNotEquals('some contents!!', $file->get(), 'Original file should not have been decrypted');
        $this->assertEquals('some contents!!', $destinationFile->get());
    }
}
