@extends('Core::layouts.participant')

@section('page_heading', $pageTitle = sprintf('#%s - %s', $participant->getId(), $name = $participant->getFullName()))
@section('page_breadcrumb', $pageTitle)

@section('page_content')
    <div class="form-horizontal">
        <div class="row form-affix-container">
            @include('Core::partials.menu')
            <div class="col-sm-9 form-affix-body">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h2 class="box-title">{{ $name }}'{{ ends_with($name, 's') ? '' : 's' }} Participation History</h2>
                    </div>
                    <div class="box-body">
                        {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
@endsection
