<form action="{{ route('admin.import.store') }}" method="post" enctype="multipart/form-data">
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title">Import Data</h3>
        </div>
        <div class="box-body">
            <div class="form-group {{ $errors->has('type') ? 'has-error' : '' }}">
                <label for="import-type">Import Type</label>
                <select required name="type" id="import-type" class="form-control select2" required>
                    <option value="">--- select ---</option>
                    @foreach ($allowedTypes as $class => $label)
                    <option {{ old('type') == $class ? ' selected' : '' }} value="{{ $class }}">{{ $label }}</option>
                    @endforeach
                </select>
                @if ($errors->has('type'))
                    <span class="help-block">{{ $errors->first('type') }}</span>
                @endif
            </div>
            <div class="form-group {{ $errors->has('file') ? 'has-error' : '' }}">
                <label for="import-type">Import File</label>
                <input class="filestyle" required type="file" name="file" accept=".csv, text/csv" />
                @if ($errors->has('file'))
                    <span class="help-block">{{ $errors->first('file') }}</span>
                @else
                    <span class="help-block">* Only .csv files are supported.</span>
                @endif
            </div>
        </div>
        <div class="box-footer">
            {{ csrf_field() }}
            <button class="btn btn-primary pull-right" type="submit">
                <strong>Upload</strong>
                <span class="fa fa-chevron-right"></span>
            </button>
        </div>
    </div>
</form>
