<?php

namespace Ignite\Core\Tests\Unit\Entities\Filters;

use Ignite\Core\Entities\Filters\QueryPermissionFilters;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Tests\TestCase;
use Illuminate\Support\Facades\Config;

class QueryPermissionFiltersTest extends TestCase
{
    /** @test */
    public function can_register_a_class_to_be_responsible_for_a_permission()
    {
        // Pre-check
        $this->assertNull(QueryPermissionFilters::for('some.permission'));

        // Execute
        Config::set('core.query_filters.permissions', ['some.permission' => DummyParticipantQueryPermissionFilter::class]);
        $instance = QueryPermissionFilters::for('some.permission');

        // Check
        $this->assertInstanceOf(DummyParticipantQueryPermissionFilter::class, $instance);
    }

    /** @test */
    public function can_only_register_scoped_permission_classes()
    {
        // Arrange
        Config::set('core.query_filters.permissions', ['some.permission' => Participant::class]);

        // Check
        $this->expectException(\UnexpectedValueException::class);

        // Execute
        QueryPermissionFilters::for('some.permission');
    }
}
