<?php

namespace Ignite\Core\Tests\Unit\Entities\Filters;


use Ignite\Core\Entities\Filters\BaseQueryPermissionFilter;
use Ignite\Core\Entities\Participant;
use Ignite\Core\Entities\User;

class DummyParticipantQueryPermissionFilter extends BaseQueryPermissionFilter
{
    /**
     * Gives you the entity class this provider scope is for.
     *
     * @return string
     */
    public function modelClass(): string
    {
        return Participant::class;
    }

    /** {@inheritdoc} */
    protected function buildWhereExistsQuery($query, string $innerAlias, string $outerTableName, ?User $user = null)
    {
        $query = parent::buildWhereExistsQuery($query, $innerAlias, $outerTableName, $user);

        if (! $user) {
            return $query;
        }

        $types = ['Type1'];
        if ($user->participant->state === 'TX') {
            $types = $this->permission === 'core.user.participant.browse'
                ? ['Type1', 'Type2']
                : ['Type1'];
        } else if ($user->participant->state === 'NM') {
            $types = ['Type3'];
        }

        // All other authed users see Type1 & their selves
        return $query->where(function ($query) use ($types, $user) {
            $query->where('user_id', $user->getKey())
                ->orWhereIn('type', $types);
        });
    }
}
