<?php

namespace Ignite\Core\Entities\Filters;

use Ignite\Core\Contracts\Entities\Filters\QueryPermissionFilter;

/**
 * The purpose of a scoped permissions class is to filter queries for an entity/model based on a permission, and in
 * most cases, a user. By default, it will add an EXISTS() clause to the query. All it asks is that the query have
 * the entity's/model's table in the query somewhere (via FROM or JOIN).
 */
abstract class BaseQueryPermissionFilter extends BaseQueryFilter implements QueryPermissionFilter
{
    /**
     * @see forPermission
     * @var string
     */
    protected $permission;

    /**
     * {@inheritdoc}
     */
    public function forPermission(string $permission): QueryPermissionFilter
    {
        $this->permission = $permission;

        return $this;
    }
}
