<?php

namespace Ignite\Core\Domains\Dashboard;

abstract class Metric
{
    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $label;

    /**
     * @var string
     */
    public $uniqueKey;

    /**
     * @return string
     */
    public function name()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function label()
    {
        return $this->label;
    }

    /**
     * @return string
     */
    public function uniqueKey()
    {
        return $this->uniqueKey;
    }

    public function context()
    {

    }

    public function range()
    {

    }

    /**
     * @return mixed
     */
    abstract public function query();

    /**
     * @return mixed
     */
    abstract public function view();

    /**
     * @return mixed
     */
    abstract public function render();
}
