<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Yajra\DataTables\DataTables;

class UserTable extends QueryTable
{
    /**
     * @var UserFormatter
     */
    protected $formatter;

    /**
     * UserTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param UserFormatter $formatter
     * @param array $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        UserFormatter $formatter,
        array $params = [])
    {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'action' => [
                'name' => 'actions',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '200px',
                'class' => 'actions'
            ],
            'user_id' => [
                'title' => 'User ID',
                'name' => 'user.user_id',
                'orderable' => true,
                'exportable' => true,
            ],
            'name' => [
                'title' => 'Group(s)',
                'name' => 'group_name',
                'orderable' => true,
                'exportable' => true,
                'searchable' => false
            ],
            'first' => [
                'title' => 'First',
                'name' => 'user.first',
                'orderable' => true,
                'exportable' => true,
            ],
            'last' => [
                'title' => 'Last',
                'name' => 'user.last',
                'orderable' => true,
                'exportable' => true,
            ],
            'email' => [
                'title' => 'E-mail',
                'name' => 'user.email',
                'orderable' => true,
                'exportable' => true,
            ],
            'internal' => [
                'title' => 'Type',
                'name' => 'user.internal',
                'orderable' => true,
                'exportable' => true,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'user.status',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => 'Created',
                'name' => 'user.created_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'last_login_at' => [
                'title' => 'Last Login',
                'name' => 'user.last_login_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'updated_at' => [
                'title' => 'Last Updated',
                'name' => 'user.updated_at',
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The user query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())
            ->keyBy('name')
            ->except(['actions', 'group_name'])
            ->keys()
            ->toArray();

        return $this->getConnection()
            ->table('core_user as user')
            ->select($columns)
            ->addSelect($this->getConnection()->raw('GROUP_CONCAT(group.name SEPARATOR ", ") as group_name'))
            ->leftJoin('core_user_group', 'core_user_group.user_id', '=', 'user.user_id')
            ->leftJoin('core_group as group', 'core_user_group.group_id', '=', 'group.id')
            ->groupBy('user.user_id');
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'action' => [$this->formatter, 'actions'],
            'name' => [$this->formatter, 'group'],
            'first' => [$this->formatter, 'first'],
            'last' => [$this->formatter, 'last'],
            'email' => [$this->formatter, 'email'],
            'internal' => [$this->formatter, 'type'],
            'status' => [$this->formatter, 'status'],
            'created_at' => [$this->formatter, 'createdAt'],
            'updated_at' => [$this->formatter, 'updatedAt'],
            'last_login_at' => [$this->formatter, 'lastLoginAt'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        return parent::getBuilderParameters([
            'order' => [
                [2, 'asc'] // Name
            ]
        ]);
    }
}
