<?php

namespace Ignite\Core\Events;

use Ignite\Core\Entities\User;
use Illuminate\Queue\SerializesModels;

class ImpersonationStopped
{
    use SerializesModels;

    /**
     * @var User
     */
    public $impersonator;

    /**
     * @var User
     */
    public $impersonated;

    /**
     * Create a new event instance.
     *
     * @param User $impersonator
     * @param User $impersonated
     */
    public function __construct($impersonator, $impersonated)
    {
        $this->impersonator = $impersonator;
        $this->impersonated = $impersonated;
    }
}
