@extends('Core::layouts.participant')

@php
    $transactionCount = $participant->getTransactionCount();
@endphp

@section('page_heading', $pageTitle = sprintf('Delete #%s - %s', $participant->getKey(), $name = $participant->getFullName()))
@section('page_breadcrumb', $pageTitle)

@section('page_content')
    <div class="row">
        <div class="col-md-6 col-md-offset-3" style="margin-top: 100px;">
            <form action="{{route('admin.participant.destroy', $participant->getId())}}" method="post">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title">{{ $participant->getFullName() }} <small class="muted">{{ $participant->getType() }}</small></h3>
                    </div>
                    <div class="box-body">
                        @if ($transactionCount > 0)
                            <p><span class="fa fa-ban text-danger"></span> {{ $participant->getFullName() }} has {{ $transactionCount }} existing transaction {{ str_plural('record', $transactionCount) }}.</p>
                            <p class="text-danger"><strong>You cannot delete this participant until tax reports have been submitted.</strong></p>
                            <p>These records must be kept for the duration of the program.</p>
                        @else
                            <p class="text-success"><span class="fa fa-check text-success"></span> Participant has no transactions and can be deleted.</p>
                        @endif
                    </div>
                    <div class="box-footer">
                        <a href="{{ route('admin.participant.index') }}" class="btn btn-default"><span class="fa fa-chevron-left"></span> Back to List</a>
                        <a href="{{ route('admin.participant.show', $participant->getId()) }}" class="btn btn-default"><span class="fa fa-user"></span> View Participant</a>
                        @if (!$transactionCount)
                            @can('core.user.participant.delete')
                            <button class="btn btn-danger pull-right" type="submit">Delete {{ $participant->getFullName() }}</button>
                            @endcan
                            @cannot('core.user.participant.delete')
                                <p class="text-danger"><span class="fa fa-times"></span> You are not authorized to delete participants.</p>
                            @endcannot
                        @endif
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
