<table class="table table-bordered table-striped">
    <tbody>
    @forelse ($lines as $number => $line)
        <tr data-tooltip="Click to show context" @if (isset($line['context'])) onclick="return $(this).closest('tr').next('tr').toggleClass('hidden')" @endif>
            <td>
                <span class="fa fa-{{ $line['icon'] }} {{ $line['color'] }}"></span>
            </td>
            <td>
                <span class="{{ $line['color'] }}">{{ $line['message'] }}</span>
            </td>
        </tr>
        @if (isset($line['context']))
            <tr class="hidden">
                <td colspan="2" class="no-padding">
                    @if (isset($line['context']['errors']))
                        <div class="alert alert-warning no-margin no-radius">
                            <h4><i class="icon fa fa-exclamation-triangle"></i> Errors</h4>
                            @if (is_array($line['context']['errors']))
                                <ul class="no-margin">
                                    @foreach ($line['context']['errors'] as $group)
                                        @foreach ($group as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        @php unset($line['context']['errors']) @endphp
                    @endif
                    @if (isset($line['context']) && is_array($line['context']))
                        @foreach ($line['context'] as $field => $value)
                            <dl class="ig-list-horizontal dl-horizontal no-margin">
                                <dt class="ig-list-horizontal-label">{{ title_case($field) }}</dt>
                                <dd class="ig-list-horizontal-value">
                                    @if (is_array($value))
                                        @if (empty($value))
                                            {{ __('No data') }}
                                        @else
                                            @php $headers = array_keys($value[0]); @endphp
                                            <table class="table table-bordered table-condensed m-0" cellpadding="0" cellspacing="0">
                                                <thead>
                                                <tr class="active">
                                                    @foreach ($headers as $header)
                                                        <th>
                                                            {{ $header }}
                                                        </th>
                                                    @endforeach
                                                </tr>
                                                </thead>
                                                <tbody>
                                                @foreach ($value as $row)
                                                    <tr>
                                                        @foreach ($headers as $header)
                                                            <td>
                                                                {{ $row[$header] }}
                                                            </td>
                                                        @endforeach
                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        @endif
                                    @else
                                        {{ $value }}
                                    @endif
                                </dd>
                            </dl>
                        @endforeach
                    @endif
                </td>
            </tr>
        @endif
    @empty
        <tr>
            <td colspan="2" class="text-danger text-center">{{ request()->has('onlyErrors') ? 'No errors found.' : 'The log is empty.' }}</td>
        </tr>
    @endforelse
    </tbody>
</table>
@php
    $appends = ['dryRun' => $dryRun];
    if (request()->has('onlyErrors')) {
        $appends['onlyErrors'] = true;
    }
    if (request()->has('onlyImported')) {
        $appends['onlyImported'] = true;
    }
@endphp
{{ $lines->appends($appends)->links() }}
