F: New Feature / Enhancement
B: Breaking
X: Bug Fix

# 3.0.26

- [XB] config/datatables-buttons.php parameters.buttons was basically being ignored so we can not configure all buttons for all reports. It is fixed now so it does use that configuration to merge in Ignite\Core\Models\Grid\AbstractTable.
- [X] Removed distinct() from some queries because it may be hiding some bugs. Your query should return distinct values anyway and not need distinct() on most occasions. But if there are duplicate values or rows, then the distinct() could be hiding duplicate rows in the database or a bad join, and we need to see those instead not knowing of their existence.
- [X] Fix DefaultStragey when creating or updating users/participants so it uses the User or Participant binded by the program (like Program\Entities\User) instead of just using the one from Core. So you can get a return class type based off the binding instead of having to manually replace the object with your new object.

# 3.0.25

- [X] Removed fast-excel from the UserTable and the TaxReport.

# 3.0.24

- [X] When generating a filename for the next import, we're now making sure there isn't a file with that name already.
  This means if we create two import records within the same second, we can now generate unique file names for those two
  imports. For the Traveler's MyClick (Bond) project, we need to run 8 imports to migrate the data from the previous
  system. I created a command, so we can run this predictably to test setting up the site and to set up the database
  locally & in beta. And, when we're ready to go-live, we can run this same command as part of bootstrapping the site.
  This command creates the 8 imports in the import table and copies the import files for those import records. It then
  queues up a chain of jobs that will run the imports in sequence. So, this is kinda not really a bug since the
  likelihood of two imports being uploaded at the same time is very likely. But, these changes are more of a bug fix
  than an enhancement, so I went with bug fix on this one.

# 3.0.23

- [F] Added the ability to create an import file based on a path (`\Ignite\Core\Models\Import\File::fromPath()`). We
  previously had the ability to create an import file from a Request. This does the same thing, but instead of asking
  for a request, it asks for a file path, an import type and optionally, a disk.
- [F] Added the ability to create an Import entity based on an import file (`\Ignite\Core\Models\Import\File`). Prior to
  this, we needed to pass in an array of the data for the import. This new method (`ImportRepository->createFromFile()`)
  gets the majority of the information we need from the file. You can optionally pass a created_by user. I wanted to
  make the `ImportRepository-->create()` method take either an array or a File instance, but I also didn't want to
  change its signature in order to allow for the created by user to be passed in.
- [F] Added a `findAdminUser()` method to the `UserRepository`. This fetches the user with
  the `config('core.admin.email')`, email address.
- [F] When creating an Import entity, we use the admin user's ID (see previous bullet) if we don't have a logged-in
  user. We were using ID of `1` in this case. We're still falling back to using `1` if we can't find an admin user,
  though maybe we should remove that now.

# 3.0.21

- [X] There was an issue fetching the message out of log lines that had a `{` or `[` in them. The changes here allow for
  any characters in log messages when formatting them. In order to enjoy these changes, you will need to update
  the `config/core.php` file's `core.import.reader.pattern` regex. If this setting was set specifically for your
  program, make sure to only apply this change if you know it won't affect how your program currently works.

# 3.0.20

- [B] The config core.seeder.path now has a default of 'modules/Program/database/data' instead of null.
- [F] Several new composer scripts are available, including: php-security-checker, dos2unix, php-lint,
  php-code-beautify, php-code-style, and php-copy-paste-detector.
- [F] The seeders now can be extended and provide a different json file name, like for your own module. So instead of
  copy-paste the whole class to provide an additional json file (and not a replacement), you can just extend the
  appropriate seeder and provide a different name with the $file property. If you actually wanted a replacement json
  using the same seeder class, see config('core.seeder.path').

# 3.0.14

- [F] You may want to add POSTMARK_MESSAGE_STREAM_ID to your .env file.
- [B] If you are already handling postmark message stream in a different way in existing applications, you may want to
  switch over to the new environment variable, and use the EventServiceProvider in Core instead of handling it in your
  program's PrograServiceProvider or EventServiceProvider.